/*
 * Decompiled with CFR 0.152.
 */
package jade.util.leap;

import jade.util.leap.Properties;
import java.io.IOException;
import java.util.Enumeration;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;

public class Config
extends MIDlet
implements CommandListener {
    private static final String CONFIG_RS = "conf";
    private static final Command setCommand = new Command("Set", 1, 0);
    private static final Command saveCommand = new Command("Save", 1, 1);
    private static final Command clearCommand = new Command("Clear", 1, 1);
    private static final Command exitCommand = new Command("Exit", 1, 1);
    private static final Command okCommand = new Command("OK", 4, 0);
    private static final Command cancelCommand = new Command("Cancel", 3, 0);
    private static final Command yesCommand = new Command("Yes", 4, 0);
    private static final Command noCommand = new Command("No", 3, 0);
    private Display display = Display.getDisplay((MIDlet)this);
    private Form main;
    private Form set;
    private Form last;
    private Form error;
    private TextField keyTxt;
    private TextField valueTxt;
    private boolean modified = false;

    public void startApp() {
        this.main = new Form("Configuration");
        this.main.addCommand(setCommand);
        this.main.addCommand(clearCommand);
        this.main.addCommand(saveCommand);
        this.main.addCommand(exitCommand);
        this.main.setCommandListener((CommandListener)this);
        this.set = new Form("Set property");
        this.set.addCommand(okCommand);
        this.set.addCommand(cancelCommand);
        this.keyTxt = new TextField("key", null, 64, 0);
        this.valueTxt = new TextField("value", null, 64, 0);
        this.set.append((Item)this.keyTxt);
        this.set.append((Item)this.valueTxt);
        this.set.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)this.main);
        this.load();
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
    }

    public void commandAction(Command c, Displayable d) {
        if (d == this.main) {
            if (c == setCommand) {
                this.display.setCurrent((Displayable)this.set);
            } else if (c == clearCommand) {
                this.clear();
            } else if (c == saveCommand) {
                this.save();
            } else if (c == exitCommand) {
                this.exit();
            }
        } else if (d == this.set) {
            if (c == okCommand) {
                this.grab(this.keyTxt.getString(), this.valueTxt.getString());
            }
            this.keyTxt.setString(null);
            this.valueTxt.setString(null);
            this.display.setCurrent((Displayable)this.main);
        } else if (d == this.last) {
            if (c == yesCommand) {
                this.save();
            }
            this.notifyDestroyed();
        } else if (d == this.error) {
            this.notifyDestroyed();
        }
    }

    private void load() {
        Properties props = new Properties();
        try {
            props.load(CONFIG_RS);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        this.modified = false;
        Enumeration keys = props.keys();
        while (keys.hasMoreElements()) {
            String k = (String)keys.nextElement();
            String v = props.getProperty(k);
            this.main.append((Item)new StringItem(k, "=" + v));
        }
    }

    private void save() {
        try {
            Properties props = new Properties();
            int size = this.main.size();
            int i = 0;
            while (i < size) {
                StringItem si = (StringItem)this.main.get(i);
                props.setProperty(si.getLabel(), si.getText().substring(1));
                ++i;
            }
            props.store(CONFIG_RS);
            this.modified = false;
        }
        catch (IOException ioe) {
            this.showError("Storing error: " + ioe.getMessage());
        }
    }

    private void clear() {
        while (this.main.size() > 0) {
            this.main.delete(0);
        }
        this.modified = true;
    }

    private void exit() {
        if (this.modified) {
            this.last = new Form("");
            this.last.append((Item)new StringItem(null, "Save before exiting?"));
            this.last.addCommand(yesCommand);
            this.last.addCommand(noCommand);
            this.last.setCommandListener((CommandListener)this);
            this.display.setCurrent((Displayable)this.last);
        } else {
            this.notifyDestroyed();
        }
    }

    private void grab(String key, String value) {
        if (key != null && !(key = key.trim()).equals("")) {
            int i = this.search(key);
            if (i >= 0) {
                if (value != null && !value.trim().equals("")) {
                    StringItem si = (StringItem)this.main.get(i);
                    si.setText("=" + value.trim());
                } else {
                    this.main.delete(i);
                }
            } else if (value != null && !(value = value.trim()).equals("")) {
                StringItem si = new StringItem(key, "=" + value);
                this.main.append((Item)si);
            }
            this.modified = true;
        }
    }

    private int search(String key) {
        int size = this.main.size();
        int i = 0;
        while (i < size) {
            StringItem si = (StringItem)this.main.get(i);
            if (si.getLabel().equals(key)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void showError(String msg) {
        this.error = new Form("ERROR");
        this.error.append((Item)new StringItem(null, msg));
        this.error.addCommand(okCommand);
        this.error.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)this.error);
    }
}

